<?php
/**
 * The template for displaying product category thumbnails within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product_cat.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 2.6.1
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

?>
<div <?php wc_product_cat_class( 'col-md-3 col-sm-6 same_height custom-product  wow fadeIn', $category ); ?> data-wow-duration="2s">
    <?php
    /**
     * woocommerce_before_subcategory hook.
     *
     * @hooked woocommerce_template_loop_category_link_open - 10
     */
    do_action( 'woocommerce_before_subcategory', $category );
    ?>
    <div class="featured_product_box">
        <div class="featured_image">
            <?php do_action( 'woocommerce_before_subcategory_title', $category ); ?>
        </div>
        <?php do_action( 'woocommerce_shop_loop_subcategory_title', $category ); ?>
        <h3><?php the_field('cat_pro_range',$category); ?></h3>
        <?php do_action( 'woocommerce_after_subcategory_title', $category ); ?>
    </div>
    <?php
    /**
     * woocommerce_after_subcategory hook.
     *
     * @hooked woocommerce_template_loop_category_link_close - 10
     */
    do_action( 'woocommerce_after_subcategory', $category ); ?>
</div>