<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since 1.0.0
 */

get_header();
?>
	<section id="primary" class="content-area">
		<main id="main" class="site-main">
            <div class="container-fluid">
                <div class="row inner_containers">
                    <div class="col-md-12 border_bottom p_b_50">
                        <div class="error-404 not-found">
                            <header class="page-header" style="position: relative;border: none;">
                                <h1 class="page-title"><?php _e( '404 Page not found', 'twentynineteen' ); ?></h1>
                            </header><!-- .page-header -->

                            <div class="page-content">
                                <p>The page you requested cannot be found. The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</p>
                                <h4>Please try the following:</h4>
                                <ul>
                                    <li>If you typed the page address in the Address bar, make sure that it is spelled correctly.</li>
                                    <li>Open the <a href="<?php echo site_url(); ?>">home page</a> and look for links to the information you want.</li>
                                    <li>Use the navigation bar on the left or top to find the link you are looking for.</li>
                                    <li>Click the Back button to try another link.</li>
                                </ul>
                            </div><!-- .page-content -->
                        </div><!-- .error-404 -->
                    </div>
                </div>
            </div>
		</main><!-- #main -->
	</section><!-- #primary -->

<?php
get_footer();
