<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php if (is_404()): echo "Page Not Found"; else: echo get_the_title(); endif; echo " - ".get_bloginfo(); ?></title>
    <?php
    $favicon=get_field('favicon','option');
    if (!empty($favicon)):
        echo "<link rel=\"icon\" type=\"image/x-icon\" href=\"$favicon\">";
    endif; ?>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<header class="container-fluid">
    <div class="row preheader">
        <div class="   ">
            <div class="logos_head">
                <?php
                if( have_rows('logos','options') ):
                    while ( have_rows('logos','options') ) : the_row(); ?>
                        <?php $b_logo = get_sub_field('b_logo'); ?>
                        <img src="<?= $b_logo['url']; ?>" alt="<?= $b_logo['alt']; ?>"/>
                    <?php endwhile;
                endif;
                wp_reset_postdata();
                ?>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="tablee">
            <div class="tablee_cell col-md-6 col-sm-6">
                <nav class="navbar">
                    <div class="collapse navbar-collapse" id="myNavbar">
                        <?php
                        wp_nav_menu(
                            array(
                                'menu' => false,
                                'theme_location' => 'header_menu',
                                'link_before' => false,
                                'link_after' => false,
                                'menu_class' => "nav navbar-nav",
                                'menu_id' => false,
                                'container' => false,
                            )
                        );
                        ?>
                    </div>
                </nav>
            </div>
            <div class="tablee_cell  logo_sectionss">
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#myNavbar">
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <?php
                    $logo = get_field('logo','options');
                    if( !empty($logo) ): ?>
                        <a class="navbar-brand" href="<?= site_url(); ?>">
                            <img src="<?php echo $logo['url']; ?>" alt="<?php echo $logo['alt']; ?>" class="logo" />
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="tablee_cell col-md-6 col-sm-6 side_icons right_side_sections">
                <div class="row">
                    <div class="col-md-11">
                        <ul class="nav navbar-nav navbar-right side_menus">
                            <li class="active"><a href="#"><img src="<?= get_template_directory_uri(); ?>/images/search_icon.png"/></a></li>
                            <li class="active"><a href="#"><img src="<?= get_template_directory_uri(); ?>/images/user_icon.png"/></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
