<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
    //echo get_the_password_form(); // WPCS: XSS ok.
    return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
    <section class="container-fluid">
        <div class="row  inner_containers">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-sm-6   product_sliders">
                        <div id="myCarousel" class="carousel slide" data-ride="carousel">
                            <!-- Indicators -->
                            <?php
                            $proimges = 0;
                            if( have_rows('proimges') ): ?>
                            <ol class="carousel-indicators">
                                <?php while ( have_rows('proimges') ) : the_row(); ?>
                                    <?php $prr_img = get_sub_field('prr_img'); ?>
                                    <li data-target="#myCarousel" data-slide-to="<?= $proimges; ?>" class="active" style="background:url(<?= $prr_img['url']; ?>) center center / contain no-repeat;"></li>
                                <?php $proimges++; endwhile; ?>
                            </ol>
                            <?php endif; ?>

                            <!-- Wrapper for slides -->
                            <div class="carousel-inner">
                                <?php
                                $proimges = 0;
                                if( have_rows('proimges') ):
                                    while ( have_rows('proimges') ) : the_row(); $proimges++; ?>
                                        <div class="item <?php if ($proimges == 1) : ?>active<?php endif; ?>">
                                            <?php $prr_img = get_sub_field('prr_img'); ?>
                                            <img src="<?= $prr_img['url']; ?>" alt="<?= $prr_img['alt']; ?>">
                                        </div>
                                    <?php endwhile;
                                endif;
                                wp_reset_postdata();
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 text-center product_details p_t_50">
                        <div class="row">
                            <div class="col-md-10 col-md-offset-1">


                                <a href="#" class="heart_icons"><i class="fa fa-heart-o"></i></a>
                                <h3>628</h3>
                                <h2><?php woocommerce_template_single_title(); ?></h2>

                                <div class="product_desc m_b_30">
                                    <h3>BLACK</h3>

                                    <p><?php the_field('sku'); ?> <br/><?php the_field('stock'); ?> </p>
                                </div>

                                <div class="prodcut_color m_b_30">
                                    <p>INK COLOR</p>

                                    <div class="color_boxex">
                                        <a href="" class="color_box b1 active"></a>
                                        <a href="" class="color_box b2"></a>
                                    </div>
                                </div>
                                <?php
                                if( have_rows('pricing_structure') ): ?>
                                <table class="table">
                                    <thead>
                                        <tr><th colspan="2">PRICING STRUCTURE</th></tr>
                                    </thead>
                                    <tbody>
                                        <?php while ( have_rows('pricing_structure') ) : the_row(); ?>
                                            <tr><td><?php the_sub_field('quantity'); ?></td><td><?php the_sub_field('price'); ?></td></tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                                <?php endif;
                                wp_reset_postdata();
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row m0 product_details_products">
                    <hr/>
                    <div class="container">
                        <div class="row   ">
                            <h2><?php the_field('product_details_title'); ?></h2>
                            <?php the_field('product_details'); ?>
                        </div>
                    </div>
                    <hr/>
                    <div class="container">
                        <div class="row   ">
                            <h2><?php the_field('product_specs_title'); ?></h2>
                            <?php the_field('product_specs'); ?>
                        </div>
                    </div>
                    <hr/>
                    <div class="container">
                        <div class="row   ">
                            <h2><?php the_field('production_notes_title'); ?></h2>
                            <?php the_field('production_notes'); ?>
                        </div>
                    </div>
                    <hr/>
                </div>
            </div>
        </div>



    </section>
    <section class="container-fluid">
        <div class="row p40 images_sections_product">

            <div class=" col-sm-6" >
                <img src="<?= get_template_directory_uri(); ?>/images/pen_img_1.png"/>
            </div>
            <div class=" col-sm-6" >
                <img src="<?= get_template_directory_uri(); ?>/images/pen_img_2.png"/>
            </div>
            <div class=" col-sm-12 m_t_30" ><img src="<?= get_template_directory_uri(); ?>/images/pen_img_3.png"/></div>

        </div>
    </section>
    <section class="container-fluid">
        <div class="row  ">
            <div class="container">
                <?php
                    echo do_shortcode('[featured_products]');
                ?>
            </div>
        </div>
    </section>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
