<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	//echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<section class="container-fluid   ">
	<div class="row inner_containers ">
		<div class="col-md-12">
			<hr/>
		</div>

		<div class="col-md-12 m_t_30 m_b_30  wow fadeIn" >
			<div class="row m_b_20">
				<div class="tablee featured_titles">
					<div class="tablee_cell col-md-6 col-xs-8"><?php woocommerce_breadcrumb(); ?></div>
					<div class="tablee_cell col-md-6 col-xs-4 text-right">
						<div class="row">
							<div class="col-md-12    arrows_prev_next">
								<?php previous_post_link( '%link','<i class="fa fa-long-arrow-left"></i>' ) ?>
								<?php next_post_link( '%link','<i class="fa fa-long-arrow-right"></i>' ) ?>
							</div>
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>
</section>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
	<section class="container-fluid">
		<?php $product->get_id();
		?>
		<div class="row  inner_containers">
			<div class="container-fluid">
				<div class="row m_b_20  wow fadeIn">
					<div class="col-sm-6   product_sliders">
						  <div class="xzoom-container">
                              <?php woocommerce_show_product_images(); ?>
                        </div>
					</div>
					<div class="col-sm-6 text-center product_details ">
						<div class="row m0">
							<div class="col-md-12 p_t_50">

								<div class="heart_icons"><?php echo do_shortcode('[ti_wishlists_addtowishlist]'); ?></div>
                                <div id="moveMeIntoMain" class="moveMeIntoMain"></div>
								<h3><?php the_field('prdct_id'); ?></h3>
								<?php 
								$product_title = get_field('product_title'); 
								if(!empty($product_title)): ?>
								<h2><?php echo $product_title; ?></h2>
								<?php else: ?>
								<h2><?php woocommerce_template_single_title(); ?></h2>
								<?php endif; ?>

								<div class="product_desc m_b_30">
									<h3><?php the_field('pinfo_color'); ?></h3>
									<?php
									$totlePrice = 0;
									if( have_rows('pricing_structure') ): ?>
										<?php while ( have_rows('pricing_structure') ) : the_row(); ?>
											<?php $currentPrice = get_sub_field('quantity');
											$totlePrice = $totlePrice+$currentPrice; ?>
										<?php endwhile; ?>
									<?php endif;
									wp_reset_postdata();
									?>
									<p><?php //echo $product->get_sku(); ?> <br/>
                                        <?php do_action( 'woocommerce_single_product_summary' ); ?>
										<?php if($totlePrice != 0): ?>
<!--										OVER --><?php //echo $totlePrice; ?><!-- IN STOCK</p>-->
								<?php endif; ?>
								</div> 
								
								<div class="tab_contents">
									
								
								<div class="tab_head">
									<a href="javascript:void(0);" class="active" data-val="t1"><img src="<?php echo get_template_directory_uri(); ?>/images/tab_2.png" /></a>
									<a href="javascript:void(0);"  data-val="t2"><img src="<?php echo get_template_directory_uri(); ?>/images/tab_1.png" /></a>
								</div>
								<div class="tab_body">
									<div class="tab_content active t1">
										<table class="table">
											<thead>
											<tr><th colspan="2">PRICING STRUCTURE 1 </th></tr>
											</thead>
											<tbody>
												<tr><td>100</td><td>$1.99</td></tr>
												<tr><td>500</td><td>$1.88</td></tr>
												<tr><td>1000</td><td>$1.74</td></tr>
												<tr><td>50000</td><td>$1.56</td></tr>
											</tbody>
										</table>
									</div>
									<div class="tab_content t2">
										<table class="table">
											<thead>
											<tr><th colspan="2">PRICING STRUCTURE 2</th></tr>
											</thead>
											<tbody>
												<tr><td>100</td><td>$1.99</td></tr>
												<tr><td>500</td><td>$1.88</td></tr>
												<tr><td>1000</td><td>$1.74</td></tr>
												<tr><td>50000</td><td>$1.56</td></tr>
											</tbody>
										</table>
									</div>
								</div>
								</div>
								<?php
								if( have_rows('pricing_structure') ): ?>
									
									<table class="table">
										<thead>
										<tr><th colspan="2">PRICING STRUCTURE</th></tr>
										</thead>
										<tbody>
										<?php while ( have_rows('pricing_structure') ) : the_row(); ?>
											<tr><td><?php the_sub_field('quantity'); ?></td><td><?php the_sub_field('price'); ?></td></tr>
										<?php endwhile; ?>
										</tbody>
									</table>
								<?php endif;
								wp_reset_postdata();
								?>
							</div>
						</div>
					</div>
				</div>
				<div class="row m0  wow fadeIn  product_details_products list_with_dash">
					<hr/>
					<div class="container">
						<div class="row  ">
							<div class="tab_contents">
							<div class="tab_head2">
									<a href="javascript:void(0);" class="active" data-val="t1"><img src="<?php echo get_template_directory_uri(); ?>/images/tab_3.png" /></a>
									<a href="javascript:void(0);"  data-val="t2"><img src="<?php echo get_template_directory_uri(); ?>/images/tab_4.png" /></a>
									<a href="javascript:void(0);"  data-val="t3"><img src="<?php echo get_template_directory_uri(); ?>/images/tab_5.png" /></a>
									<a href="javascript:void(0);"  data-val="t4"><img src="<?php echo get_template_directory_uri(); ?>/images/tab_6.png" /></a>
									<a href="javascript:void(0);"  data-val="t5"><img src="<?php echo get_template_directory_uri(); ?>/images/tab_7.png" /></a>
								</div>
							<div class="tab_body2">
									<div class="tab_content2 active t1">
										<div class="col-md-12">
											<h2>Details 1</h2>
											<ul class="list_with_dash">
												<li>CLASSIC PUSH ACTION RETRACTABLE WITH SILVER ACCENTS</li>
												<li>ILVER ENGRAVED IMPRINT</li>
												<li>MECHNICAL PENCIL FEATURES 0.7MM LEAD AND ERASER HIDDEN BENEATH THE PLUNGER</li>
												<li>SETS: AVAILABLE AS PEN, PENCIL OR PEN AND PENCIL SET IN BLACK INK ONLY. INCLUDES A DELUXE TWO-PIECE GIFT BOX</li>
											</ul>
										</div>
									</div>
									<div class="tab_content2 t2">
										<div class="col-md-12">
											<h2>Details 2</h2>
											<ul class="list_with_dash">
												<li>CLASSIC PUSH ACTION RETRACTABLE WITH SILVER ACCENTS</li>
												<li>ILVER ENGRAVED IMPRINT</li>
												<li>MECHNICAL PENCIL FEATURES 0.7MM LEAD AND ERASER HIDDEN BENEATH THE PLUNGER</li>
												<li>SETS: AVAILABLE AS PEN, PENCIL OR PEN AND PENCIL SET IN BLACK INK ONLY. INCLUDES A DELUXE TWO-PIECE GIFT BOX</li>
											</ul>
										</div>
									</div>
									<div class="tab_content2 t3">
										<div class="col-md-12">
											<h2>Details 3</h2>
											<ul class="list_with_dash">
												<li>CLASSIC PUSH ACTION RETRACTABLE WITH SILVER ACCENTS</li>
												<li>ILVER ENGRAVED IMPRINT</li>
												<li>MECHNICAL PENCIL FEATURES 0.7MM LEAD AND ERASER HIDDEN BENEATH THE PLUNGER</li>
												<li>SETS: AVAILABLE AS PEN, PENCIL OR PEN AND PENCIL SET IN BLACK INK ONLY. INCLUDES A DELUXE TWO-PIECE GIFT BOX</li>
											</ul>
										</div>
									</div>
								<div class="tab_content2 t4">
										<div class="col-md-12">
											<h2>Details 4</h2>
											<ul class="list_with_dash">
												<li>CLASSIC PUSH ACTION RETRACTABLE WITH SILVER ACCENTS</li>
												<li>ILVER ENGRAVED IMPRINT</li>
												<li>MECHNICAL PENCIL FEATURES 0.7MM LEAD AND ERASER HIDDEN BENEATH THE PLUNGER</li>
												<li>SETS: AVAILABLE AS PEN, PENCIL OR PEN AND PENCIL SET IN BLACK INK ONLY. INCLUDES A DELUXE TWO-PIECE GIFT BOX</li>
											</ul>
										</div>
									</div>
								<div class="tab_content2 t5">
										<div class="col-md-12">
											<h2>Details 5</h2>
											<ul class="list_with_dash">
												<li>CLASSIC PUSH ACTION RETRACTABLE WITH SILVER ACCENTS</li>
												<li>ILVER ENGRAVED IMPRINT</li>
												<li>MECHNICAL PENCIL FEATURES 0.7MM LEAD AND ERASER HIDDEN BENEATH THE PLUNGER</li>
												<li>SETS: AVAILABLE AS PEN, PENCIL OR PEN AND PENCIL SET IN BLACK INK ONLY. INCLUDES A DELUXE TWO-PIECE GIFT BOX</li>
											</ul>
										</div>
									</div>
							</div>
							</div>
							<div class="col-md-12">
								<h2><?php the_field('product_details_title'); ?></h2>
								<?php the_field('product_details'); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section class="container-fluid">
		<div class="row   wow fadeIn">
			<div class="container">
				<div class="row">
					<div class="tablee featured_titles">
						<div class="tablee_cell col-xs-8"><h2 class="title_text">Related Products</h2></div>
						<div class="tablee_cell col-xs-4 text-right">

						</div>
					</div>
				</div>
				<div class="row">
					<?php
					echo do_shortcode('[related_products limit="4"]');
					?>
				</div>

			</div>
		</div>
	</section>
	<section class="container-fluid  wow fadeIn">
		<div class="row  inner_containers   m_t_90 m_b_40">
			<div class="border_bottom">

			</div>
		</div>
	</section>
	<?php  do_action( 'woocommerce_after_single_product' ); ?>
