<html>
<head>
    <title>
        <?php if (is_404()): echo "Page Not Found"; else: echo get_the_title(); endif; echo " - ".get_bloginfo(); ?>
    </title>
    <meta charset="utf-8">
    <meta name="HandheldFriendly" content="True">
    <meta name="MobileOptimized" content="320">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css"/>
	 <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap-datetimepicker.css"/>
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/font-awesome.css"/>
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/owl.carousel.css"/>
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css"/>
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/style.css"/>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/style.css"/>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<header class="container-fluid">
    <div class="row">
        <div class="container">
            <div class="row flex_col align_center">
                <div class="col-sm-6 p0 col-xs-12">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <a class="navbar-brand" href="<?php echo site_url(); ?>"><img src="<?php the_field('hlogo','options'); ?>" /></a>
                    </div>

                </div>
                <div class="col-sm-6 p0 col-xs-12 text-right header_brands">
                    <?php
                        $btntext=get_field('he_btn_text','options');
                        $btnlink=get_field('he_btn_link','options');
                        if(!empty($btntext) && !empty($btnlink)):
                    ?>
                    <a href="<?php echo $btnlink; ?>" class="btn btn-info"><?php echo $btntext; ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <nav class="navbar navbar-default">
            <div class="container">
			<div class="row">
                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse " id="bs-example-navbar-collapse-1">
                    <?php
                        wp_nav_menu(
                            array(
                                'menu' => false,
                                'theme_location' => 'menu-1',
                                'link_before' => false,
                                'link_after' => false,
                                'menu_class' => "nav navbar-nav",
                                'menu_id' => false,
                                'container' => false,
                            )
                        );
                    ?>
				</div>
                </div><!-- /.navbar-collapse -->
            </div><!-- /.container-fluid -->
        </nav>
    </div>
</header>