<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package TEYCO
 */

?>


<?php
if (have_rows('page_content')):
    while (have_rows('page_content')) :
        the_row();
        if (get_row_layout() == 'hero_section'): ?>
            <section class="container-fluid"
                     style="background: url(<?php the_sub_field('hb_img'); ?>) center center / cover no-repeat">
                <div class="row">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="banner_text">
                                    <h2><?php the_sub_field('hb_title'); ?>
                                        <span><?php the_sub_field('hbs_title'); ?></span></h2>
                                    <div class="black_lines">
                                        <h3><?php the_sub_field('hb_box_title'); ?>
                                            <span><?php the_sub_field('hbs_box_title'); ?></span></h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'content_with_bg_img'): ?>
            <section class="container-fluid"
                     style="background: url(<?php the_sub_field('cwbg_img'); ?>) center center / cover no-repeat">

                <div class="row">
                    <div class="container">
                        <div class="row  relative_pos">
                            <img src="<?php the_sub_field('cwr_img'); ?>" class="human_img"/>
                            <div class="col-md-6 col-md-offset-4 col-sm-7 col-sm-offset-5  m_t_50 m_b_30 p_b_90 after_banner_text">
                                <img src="<?php the_sub_field('cwrl_img'); ?>"/>
                                <hr class="smaller_line"/>
                                <p><?php the_sub_field('cwr_content'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'title_with_tab'): ?>
            <section class="container-fluid">
                <div class="row">
                    <div class="container">
                        <div class="row  relative_pos m_t_60 m_b_40">
                            <div class="title_text col-md-12 text-center">
                                <h2><?php the_sub_field('twb_title'); ?></h2>
                                <hr>
                                <div class="row ">
                                    <?php
                                    $i = 0;
                                    if (have_rows('tab')):
                                        while (have_rows('tab')) : the_row();
                                            $i++; ?>
                                            <div class="col-sm-4 p_t_10 <?php if ($i == 1):echo 'col-sm-offset-2';endif; ?>">
                                                <a href="javascript:void(0);"
                                                   class="btn btn-info btn-block <?php if ($i == 1):echo 'active';endif; ?> tab_head"
                                                   data-val="t<?php echo $i; ?>"><?php the_sub_field('tt_title'); ?></a>
                                            </div>
                                        <?php endwhile;
                                    endif;
                                    wp_reset_postdata();
                                    ?>
                                </div>
                                <?php
                                $i = 0;
                                if (have_rows('tab')):
                                    while (have_rows('tab')) : the_row();
                                        $i++; ?>
                                        <div class="col-md-12 tab_body t<?php echo $i; ?> <?php if ($i == 1):echo 'active';endif; ?>">
                                            <div class="row flex_col m_t_30">
                                                <?php
                                                if (have_rows('icon_title')):
                                                    while (have_rows('icon_title')) : the_row();
                                                        ?>
                                                        <div class="col-md-3 col-sm-6 col-xs-12 flex_col">
                                                            <div class="icon_boxes">
											<span class="img_icon">
												<img src="<?php the_sub_field('it_icon'); ?>">
											</span>
                                                                <h3>
                                                                    <?php the_sub_field('it_title'); ?>
                                                                </h3>
                                                            </div>
                                                        </div>
                                                    <?php endwhile;
                                                endif;
                                                wp_reset_postdata(); ?>
                                            </div>
                                        </div>
                                    <?php endwhile;
                                endif;
                                wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'inner_hero_section'): ?>
            <section class="container-fluid"
                     style="background: url(<?php the_sub_field('ihs_img'); ?>) center center / cover no-repeat">
                <div class="row">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="banner_text">
                                    <h2><?php the_sub_field('ihs_title'); ?>
                                        <span><?php the_sub_field('ihss_title'); ?></span></h2>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'service_sections'): ?>
            <section class="container-fluid">

                <div class="row">
                    <div class="container">
                        <div class="row  relative_pos  m_t_20  m_b_40">
                            <div class="col-md-10 col-md-offset-1  text-center title_text2">
                                <h3><?php the_sub_field('ss_content'); ?></h3>
                            </div>
                            <div class="  col-md-12">
                                <div class="row">
                                    <div class="col-md-10 col-md-offset-1">
                                        <div class="gray_bg_box orange_b" style="background: #f7891e;">
                                            <div class="row flex_col align_bottom">
                                                <div class="col-md-3 col-xs-12 col-sm-3  p0 "><img
                                                            src="<?php the_sub_field('ss_img'); ?>"
                                                            class="img-responsive center-block human_img2"></div>
                                                <div class="col-md-9 col-xs-12 col-sm-9">
                                                    <div class="row flex_col align_center">
                                                        <div class="col-md-8  col-xs-12 col-sm-12">
                                                            <h2><?php the_sub_field('box_title'); ?>
                                                                <span><?php the_sub_field('boxs_title'); ?></span></h2>
                                                        </div>
                                                        <div class="col-md-4 col-xs-12 text-center col-sm-12 p_b_20 p_t_20">
                                                            <?php
                                                            $sbtntext = get_sub_field('ss_btn_text');
                                                            $sbtnlink = get_sub_field('ss_btn_link');
                                                            if (!empty($sbtnlink) && !empty($sbtntext)):
                                                                ?>
                                                                <a href="<?php echo $sbtntext; ?>"
                                                                   class="btn btn-info"><?php echo $sbtntext; ?></a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-10 col-md-offset-1">
                                        <div class="row flex_col m_t_30">
                                            <?php
                                            if (have_rows('icon_box')):
                                                while (have_rows('icon_box')) : the_row(); ?>
                                                    <div class="col-md-4 col-sm-6 col-xs-12 flex_col">
                                                        <div class="icon_boxes">
											<span class="img_icon">
												<img src="<?php the_sub_field('ic_img'); ?>">
											</span>
                                                            <h3>
                                                                <?php the_sub_field('ic_title'); ?>
                                                            </h3>
                                                        </div>
                                                    </div>
                                                <?php endwhile;
                                            endif;
                                            wp_reset_postdata();
                                            ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'residenciales_service'): ?>
            <section class="container-fluid">

                <div class="row">
                    <div class="container">
                        <div class="row  relative_pos  m_t_20  m_b_40">
                            <div class="col-md-10 col-md-offset-1 text-center title_text2">
                                <h3><?php the_sub_field('rs_content'); ?></h3>
                            </div>
                            <div class="  col-md-12 text-center">
                                <div class="row">
                                    <div class="col-md-10 col-md-offset-1">
                                        <div class="gray_bg_box">
                                            <div class="row flex_col align_bottom">
                                                <div class="col-md-3 col-xs-12 col-sm-3  "><img
                                                            src="<?php the_sub_field('rsb_img'); ?>"
                                                            class="img-responsive center-block human_img2"></div>
                                                <div class="col-md-9 col-xs-12 col-sm-9">
                                                    <div class="row flex_col align_center">
                                                        <div class="col-md-8  col-xs-12 col-sm-12">
                                                            <h2><?php the_sub_field('rsb_title'); ?>
                                                                <span><?php the_sub_field('rsbs_title'); ?></span></h2>
                                                        </div>
                                                        <div class="col-md-4 col-xs-12 text-center col-sm-12 p_b_20 p_t_20"><?php
                                                            $rbtntext = get_sub_field('rsbtn_text');
                                                            $rbtnlink = get_sub_field('rsbtn_link');
                                                            if (!empty($rbtnlink) && !empty($rbtntext)):
                                                                ?>
                                                                <a href="<?php echo $rbtntext; ?>"
                                                                   class="btn btn-info"><?php echo $rbtntext; ?></a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="row flex_col m_t_30">
                                        <?php
                                        if (have_rows('service')):
                                            while (have_rows('service')) : the_row(); ?>
                                                <div class="col-md-3 col-sm-6 col-xs-12 flex_col">
                                                    <div class="icon_boxes">
											<span class="img_icon">
												<img src="<?php the_sub_field('ss_icon'); ?>">
											</span>
                                                        <h3>
                                                            <?php the_sub_field('ss_title'); ?>
                                                        </h3>
                                                    </div>
                                                </div>
                                            <?php endwhile;
                                        endif;
                                        wp_reset_postdata(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'contacto_section'): ?>
            <section class="container-fluid">
                <div class="row">
                    <div class="container">
                        <div class="row   flex_col   m_t_60  m_b_60">
                            <div class="col-sm-6 col-xs-12 title_text3">
                                <h2><?php the_sub_field('cs_title'); ?></h2>
                                <hr/>
                                <div class="phone_numbers">
                                    <?php
                                    $no1 = get_sub_field('phone_no1');
                                    if (!empty($no1)):
                                        ?>
                                        <a href="tel:<?php echo $no1; ?>"><img
                                                    src="<?php the_sub_field('phone_icon1'); ?>"/> <?php echo $no1; ?>
                                        </a>
                                    <?php endif; ?>
                                    <?php
                                    $no2 = get_sub_field('phone_no2');
                                    if (!empty($no2)):
                                        ?>
                                        <a href="tel:<?php echo $no2; ?>"><img
                                                    src="<?php the_sub_field('phone_icon2'); ?>"/> <?php echo $no2; ?>
                                        </a>
                                    <?php endif; ?>
                                </div>

                                <p><?php the_sub_field('cs_text'); ?></p>

                            </div>
                            <div class="col-sm-6 col-xs-12">
                                <?php
                                $form = get_sub_field('form_shortcode');
                                echo do_shortcode($form);
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'programe_su_service'): ?>
            <section class="container-fluid">
                <?php
                $pform = get_sub_field('programe_form');
                echo do_shortcode($pform);
                ?>
            </section>
        <?php elseif (get_row_layout() == 'content_with_right_img'): ?>
            <section class="container-fluid">
                <div class="row">
                    <div class="container">
                        <div class="row m_t_90 m_b_90">
                            <div class="col-sm-6 col-xs-12 about_text">
                                <p>
                                    <?php the_sub_field('cwri_content'); ?>
                                </p>
                            </div>
                            <div class="col-sm-6 col-xs-12">
                                <img src="<?php the_sub_field('cwri_img'); ?>" class="about_img "/>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php
        endif;
    endwhile;
endif;
?>


