<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since Twenty Nineteen 1.0
 */

?>
<footer class="container-fluid">
			<div class="row">
				<div class="container  ">
					<div class="row flex_col align_center">
						<div class="col-lg-3 col-md-12 col-xs-12">
							<img src="<?php the_field('flogo','option'); ?>" class="footer_logo"/>
						</div>
						<div class="col-lg-9  col-md-12 col-xs-12">
							<div class="row top_footer">
								<div class="col-md-4 col-xs-12">
								<?php $pnum = get_field('phone_number','option');
								if(!empty($pnum)):?>
								<a href="tel:<?php echo $pnum;?>" class="phone_footer"><i class="fa fa-phone"></i> <?php echo $pnum;?></a>
								<?php endif;?>
								</div>
								<div class="col-md-4 col-xs-12">
								<?php $eml = get_field('email_address','option');
								if(!empty($eml)):?>
								<a href="mailto:<?php echo $eml;?>" class="phone_email"><i class="fa fa-envelope"></i> <?php echo $eml;?></a>
								<?php endif;?>
								</div>
								<div class="col-md-4 col-xs-12 social">
								<?php if(have_rows('social_icon','option')):		
								while(have_rows('social_icon','option')): the_row();?>		
								<?php $sicon = get_sub_field('sicon','option');			
								$surl = get_sub_field('slinks','option');			
								if(!empty($sicon) && !empty($surl)):?>
									<a href="<?php echo $surl;?>" target="blank"><i class="fa <?php echo $sicon;?>"></i></a>
									<?php endif;?>
									<?php endwhile; endif;?>
								</div>
								
								<div class="col-md-12 col-xs-12 footer_menu">
									<?php
							wp_nav_menu(array(
							'theme_location' => 'footer',
							 'container' => false
							 ));
							 ?>
						 
								</div>
							</div>
						</div>
					</div>
					<div class="row post_footer m0">
						<?php if( pll_current_language() == 'en-us' ): ?>
							<div class="col-md-6 col-xs-12 p0"><p><?php the_field('copyright_en','option');?></p></div>
							<div class="col-md-6 col-xs-12 text-right p0"><p><?php the_field('footer_text_en','option');?></p></div>
						<?php else: ?>
							<div class="col-md-6 col-xs-12 p0"><p><?php the_field('copyright','option');?></p></div>
							<div class="col-md-6 col-xs-12 text-right p0"><p><?php the_field('footer_text','option');?></p></div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</footer>
		<?php $wh = get_field('whatsapp_link','option');
		if(!empty($wh)):?>
		<a href="<?php echo $wh;?>" class="whatsapp_icon" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/images/whatsapp.svg"></a>
		<?php endif;?>
		<?php wp_footer();?>
		<div class="modal-layer" style="/*display:none*/"></div>
	</body>
</html>