<?php
/**
 * Gilroy Foundation functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Gilroy_Foundation
 */

if ( ! function_exists( 'gilroyfoundation_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function gilroyfoundation_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Gilroy Foundation, use a find and replace
		 * to change 'gilroyfoundation' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'gilroyfoundation', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'gilroyfoundation' ),
			'menu-2' => esc_html__( 'Top Menu', 'gilroyfoundation' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'gilroyfoundation_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'gilroyfoundation_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function gilroyfoundation_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'gilroyfoundation_content_width', 640 );
}
add_action( 'after_setup_theme', 'gilroyfoundation_content_width', 0 );

/**
 * Generate custom search form
 *
 * @param string $form Form HTML.
 * @return string Modified form HTML.
 */
function wpdocs_my_search_form( $form ) {
    $form = '<form role="search" method="get" id="searchform" class="searchform" action="' . home_url( '/' ) . '" >
    <div>
    <label for="search_box_text_input" class="hidden">Search</label>
    <input type="text"   name="s" id="search_box_text_input" class="search-box-text-input" placeholder="Search"  />
    <label for="ss" class="hidden">Search</label>
    <input class="search-box-button" type="image" src="http://wpcodex.xyz/gilroyfoundation/wp-content/uploads/2019/12/search-icon.svg" id="searchsubmit" id="ss" alt="'. esc_attr__( 'Search' ) .'" />
    </div>
    </form>';

    return $form;
}
add_filter( 'get_search_form', 'wpdocs_my_search_form' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function gilroyfoundation_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'gilroyfoundation' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'gilroyfoundation' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'gilroyfoundation_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function gilroyfoundation_scripts() {
 
    wp_enqueue_style( 'gilroyfoundation-normalize', get_template_directory_uri() . '/css/normalize.min.css' );
	wp_enqueue_style( 'gilroyfoundation-main', get_template_directory_uri() . '/css/main.css' );
	wp_enqueue_style( 'gilroyfoundation-slimmenu', get_template_directory_uri() . '/ThirdParty/SlimMenu/slimmenu.css' );
	wp_enqueue_style( 'gilroyfoundation-main-style', get_stylesheet_uri() );

	wp_enqueue_script( 'gilroyfoundation-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );
	wp_enqueue_script( 'gilroyfoundation-modernizr', get_template_directory_uri() . '/ThirdParty/HTML5Boilerplate/js/modernizr-2.6.2-respond-1.1.0.min.js', array(), '20151215', true );
	wp_enqueue_script( 'gilroyfoundation-slimmenu', get_template_directory_uri() . '/ThirdParty/SlimMenu/jquery.slimmenu.js', array(), '20151215', true );
	wp_enqueue_script( 'gilroyfoundation-jquery-cycle2', get_template_directory_uri() . '/ThirdParty/Cycle2/jquery.cycle2.min.js', array(), '20151215', true );
	wp_enqueue_script( 'gilroyfoundation-main-js', get_template_directory_uri() . '/js/main.js', array(), '20151215', true );
	wp_enqueue_script( 'gilroyfoundation-search-js', get_template_directory_uri() . '/js/search.js', array(), '20151215', true );

	wp_enqueue_script( 'gilroyfoundation-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'gilroyfoundation_scripts' );

if( function_exists('acf_add_options_page') ) {
    acf_add_options_page();
}

function my_myme_types($mime_types){
    $mime_types['svg'] = 'image/svg+xml'; //Adding svg extension
    $mime_types['psd'] = 'image/vnd.adobe.photoshop'; //Adding photoshop files
    return $mime_types;
}
add_filter('upload_mimes', 'my_myme_types', 1, 1);

function prefix_nav_description( $item_output, $item, $depth, $args ) {
    if ( !empty( $item->description ) ) {
        $item_output = str_replace( $args->link_after . '</a>', '<span class="menu-item-description">' . $item->description . '</span>' . $args->link_after . '</a>', $item_output );
    }

    return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'prefix_nav_description', 10, 4 );
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

