<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Gilroy_Foundation
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	 
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11" />
    <meta name="description" content="Since 1980, the Gilroy Foundation has been improving the quality of life for people in the Gilroy area through charitable funds, grants, and scholarships." />
    <meta name="keywords" content="Gilroy, Foundation, charitable funds, grants, scholarships, community projects, financial support, membership " />
    
    <link href="//fonts.googleapis.com/css?family=Lato:400,700,900,400italic" rel="stylesheet"  >
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
    <div class="page-container">
        <!-- Standard header -->
        <div class="header-container">
            <header class="wrapper clearfix">
                <?php
                $logo = get_field('logo','option');
                if( !empty($logo) ): ?>
                <a href='<?= site_url(); ?>'>
                    <img id='header-logo' src="<?php echo $logo['url']; ?>" alt="<?php echo $logo['alt']; ?>" />
                </a>
                <?php endif; ?>
                <div id='header-social-media-box' class='header-box'>
                    <div class='header-box-inner'>
                        <?php $social_title = get_field('social_icon_title','option'); ?>
                        <span><?php echo $social_title; ?></span>
                        <?php
                        if( have_rows('social_icon','option') ):
                            while ( have_rows('social_icon','option') ) : the_row(); ?>
                                <a href='<?php the_sub_field('sc_url'); ?>' target="_blank">
                                    <?php
                                    $sc_icon = get_sub_field('sc_icon');
                                    if( !empty($sc_icon) ): ?>
                                        <img   src="<?php echo $sc_icon['url']; ?>" alt="<?php echo $sc_icon['alt']; ?>" />
                                    <?php endif; ?>
                                </a>
                            <?php endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
                <div id='header-make-donation-box' class='header-box'>
                    <div class='header-box-inner'>
                        <?php
                        $hmd_button=get_field('hmd_button','option');
                        $hmd_button_url=get_field('hmd_button_url','option');
                        if (!empty($hmd_button)&&!empty($hmd_button_url)): ?>
                            <a href='<?= $hmd_button_url; ?>' target="_blank">
                                <img alt="icon"  src='<?= get_template_directory_uri(); ?>/img/common/package-icon.svg' />
                                <span style="color:#000"><?= $hmd_button; ?></span>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div id='header-links-container'>
                    <?php
                    wp_nav_menu(
                        array(
                            'menu' => false,
                            'theme_location' => 'menu-2',
                            'link_before' => false,
                            'link_after' => false,
                            'menu_class' => "topmenu",
                            'menu_id' => false,
                            'container' => false,
                        )
                    );
                    ?>
                </div>
                <div id='header-search-container'>
                    <div class='search-box'>
                        <?php get_search_form(); ?>
                    </div>
                </div>
            </header>
        </div>
        <div class="menu-container">
            <nav class="wrapper clearfix">
                <?php
                wp_nav_menu(
                    array(
                        'menu' => false,
                        'theme_location' => 'menu-1',
                        'link_before' => false,
                        'link_after' => false,
                        'menu_class' => "slimmenu",
                        'menu_id' => false,
                        'container' => false,
                    )
                );
                ?>
            </nav>
        </div>
        <div id="content" class="site-content">
