<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Gilroy_Foundation
 */

?>
<div class="main-container">
    <div class="main wrapper clearfix">
        <?php
        $sidebar = get_field('sidebar');
        if( have_rows('content') ):
            while ( have_rows('content') ) : the_row();
                if( get_row_layout() == 'two_colout' ):
                    $two_colout_count = 0;
                    if( have_rows('two_colout') ):
                        while ( have_rows('two_colout') ) : the_row(); $two_colout_count++; ?>
                            <div class="<?php if ($two_colout_count == 1): ?>mission-lg<?php else: ?>vision-lg <?php endif; ?>">
                                <h1><?php the_sub_field('tc_title'); ?><span><?php the_sub_field('tc_subtitle'); ?></span></h1>
                                <ul>
                                    <?php
                                    if( have_rows('tc_list') ):
                                        while ( have_rows('tc_list') ) : the_row(); ?>
                                            <li><?php the_sub_field('tcr_items'); ?></li>
                                        <?php endwhile;
                                    endif;
                                    wp_reset_postdata();
                                    ?>
                                </ul>
                            </div>
                        <?php endwhile;
                    endif;
                    wp_reset_postdata(); ?>
                <?php elseif( get_row_layout() == 'sp_bn_img' ): ?>
                    <div class="main-container-banner-image">
                        <?php
                        $spb_bg_img = get_sub_field('spb_bg_img'); ?>
                        <img class="banner-image" src="<?php echo $spb_bg_img['url']; ?>" alt="<?php echo $spb_bg_img['alt']; ?>" />
                    </div>
                <?php elseif( get_row_layout() == 'home_page_banner' ): ?>
                    <!-- Banner image/slideshow -->
                    <div id='main-container-slideshow'>
                        <div class='cycle-slideshow' data-cycle-slides='> div.slideshow-slide' data-cycle-pager-template='<span>&nbsp;</span>'>
                            <div class='cycle-pager'></div>
                            <div class='slideshow-slide' style='display:block'>
                                <div class='header-top-image'>
                                    <?php $bpb_bg_img = get_sub_field('bpb_bg_img'); ?>
                                    <img src="<?php echo $bpb_bg_img['url']; ?>" alt="<?php echo $bpb_bg_img['alt']; ?>" />
                                </div>
                                <div class='header-top-message'>
                                    <?php $bpb_msg_img = get_sub_field('bpb_msg_img'); ?>
                                    <img src="<?php echo $bpb_msg_img['url']; ?>" alt="<?php echo $bpb_msg_img['alt']; ?>" />
                                    <a class='slideshow-button' href='<?php the_sub_field('hpb_button_url'); ?>' target='_blank'>
                                        <?php $hpb_button = get_sub_field('hpb_button'); ?>
                                        <img src="<?php echo $hpb_button['url']; ?>" alt="<?php echo $hpb_button['alt']; ?>" />
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php elseif( get_row_layout() == 'main_content' ): ?>
                    <article <?php if (get_sub_field('sidebar') == 'yes'): ?> class="full-page-width" <?php endif; ?>>
                        <?php if (!is_front_page()): ?><h1><?php the_title(); ?></h1><?php endif; ?>
                        <?php the_sub_field('mc_content'); ?>
                    </article>
                    <?php if(get_sub_field('sidebar') != 'yes'): ?>
                        <aside <?php if (is_front_page()): ?> id='home-page-aside' <?php endif; ?>>
                            <?php the_sub_field('sidebar_content'); ?>
                        </aside>
                    <?php endif; ?>
                <?php elseif( get_row_layout() == 'directors' ): ?>
                <article class="full-page-width">
                    <?php
                    if( have_rows('directors_list') ):
                        while ( have_rows('directors_list') ) : the_row(); ?>
                            <div class="multicolumn" style="float:left;width:25%">
                                <?php $dire_img = get_sub_field('dire_img'); ?>
                                <img class="flexImage" src="<?php echo $dire_img['url']; ?>" alt="<?php echo $dire_img['alt']; ?>" />
                            </div>
                            <div class="multicolumn" style="float:right;width:70%;">
                                <h2 style="margin-top:2em;"><?php the_sub_field('dire_title'); ?></h2>
                                <?php the_sub_field('dire_content'); ?>
                            </div>
                            <div style="clear:both"></div>
                        <?php endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                    </article>
                <?php endif;
            endwhile;
        endif;
        ?>
    </div> <!-- #main -->
</div> <!-- #main-container -->
<!-- #post-<?php the_ID(); ?> -->
