<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Zapp
 */

?>
<?php get_header(); ?>
<?php
if (have_rows('content')):
    while (have_rows('content')) : the_row();
        if (get_row_layout() == 'home_hero_banner'): ?>
            <section class="container-fluid home_hero_banner"
                     style="background: #f5f5f5 url(<?php the_sub_field('hhb_bg_img'); ?>) center bottom / cover no-repeat">
                <div class="row">
                    <div class="container">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="banner_text">
                                    <h2><?php the_sub_field('hhb_title'); ?></h2>
                                    <?php
                                    $hbutton = get_sub_field('hhb_btn_text');
                                    $hurl = get_sub_field('hhb_btn_link');
                                    if (!empty($hbutton) && !empty($hurl)):
                                        ?>
                                        <a href="<?php echo $hurl; ?>"
                                           class="btn btn-primary"><?php echo $hbutton; ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'map_with_information'): ?>
			<?php
				$bigmap=get_sub_field('is_bigger_map');
				if(!empty($bigmap)): ?>
				   <section class="container-fluid map_with_information" style="background: <?php the_sub_field('bg_color'); ?>" >
			<div class="row">
				<div class="container bigger m_t_70  m_b_70">
					<div class="row flex_col align_center">
						<div class="col-sm-8  col-xs-12">
							<!--<img src="images/map.png" class="img-responsive" />-->
							<div id="map" style="width: 100%; height: 400px;"></div>
						</div>
						<div class="col-sm-4 col-xs-12 title_text">
							   <h2><?php the_sub_field('mi_title'); ?></h2>
                                <?php
                                $type = get_sub_field('mi_type');
                                if (!empty($type)):
                                    ?>
                                    <p><strong>Connector Type : </strong><?php echo $type; ?></p>
                                <?php endif; ?>
                                <?php
                                $power = get_sub_field('mi_power');
                                if (!empty($power)):
                                    ?>
                                    <p><strong>Power:</strong> <?php echo $power; ?></p>
                                <?php endif; ?>
                                <?php
                                $commingsoon = get_sub_field('cos_icon');
                                $live = get_sub_field('live_icon');
                                if (!empty($commingsoon) || !empty($live)):
                                    ?>
                                    <p><strong>Status:</strong></p>
                                    <p class="img_with">
                                    <span><img src="<?php echo $live; ?>"
                                               class="gray_ic"> Live</span>
                                        <span><img src="<?php echo $commingsoon; ?>"
                                                   class="gray_ic"> Comming Soon</span>

                                    </p>
                                    <?php if( get_sub_field('button_titlemp') != ""){ ?> 
								    <p><a href="<?php the_sub_field('button_linkmp'); ?>" class="btn btn-primary m_t_10"><?php the_sub_field('button_titlemp'); ?></a></p> 
								    <?php } ?>
                                <?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</section>
			<?php else: ?>
            <section class="container-fluid map_with_information"  style="background: <?php the_sub_field('bg_color'); ?>">
                <div class="row">
                    <div class="container <?php if(is_page('host')):echo'm_t_40  m_b_40';
elseif(is_page('charge')):echo'm_b_70 m_t_70 ';
else:echo'm_b_70';endif; ?> ">
                        <div class="row flex_col align_center">
                            <div class="col-sm-6 col-xs-12">
                                <!--<img src="images/map.png" class="img-responsive" />-->
                                <div id="map" style="width: 100%; height: 400px;"></div>
                            </div>
                            <div class="col-sm-5 col-xs-12 col-sm-offset-1 title_text">
                                <h2><?php the_sub_field('mi_title'); ?></h2>
                                <?php
                                $type = get_sub_field('mi_type');
                                if (!empty($type)):
                                    ?>
                                    <p><strong>Connector Type : </strong><?php echo $type; ?></p>
                                <?php endif; ?>
                                <?php
                                $power = get_sub_field('mi_power');
                                if (!empty($power)):
                                    ?>
                                    <p><strong>Power:</strong> <?php echo $power; ?></p>
                                <?php endif; ?>
                                <?php
                                $commingsoon = get_sub_field('cos_icon');
                                $live = get_sub_field('live_icon');
                                if (!empty($commingsoon) || !empty($live)):
                                    ?>
                                    <p><strong>Status:</strong></p>
                                    <p class="img_with">
                                    <span><img src="<?php echo $live; ?>"
                                               class="gray_ic"> Live</span>
                                        <span><img src="<?php echo $commingsoon; ?>"
                                                   class="gray_ic"> Comming Soon</span>

                                    </p>
                                    <?php if( get_sub_field('button_titlemp') != ""){ ?> 
								    <p><a href="<?php the_sub_field('button_linkmp'); ?>" class="btn btn-primary m_t_10"><?php the_sub_field('button_titlemp'); ?></a></p> 
								    <?php } ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
			<?php endif; ?>
            <script type="text/javascript">
                <?php
                $featured_posts = get_sub_field('map_locations');
                if( $featured_posts ): ?>

                var locations = [
                    <?php  $i = 0;
                    foreach( $featured_posts as $post ):$i++;
                    setup_postdata($post);
                    $location = get_field('location_map');

                    ?>
                    ['<strong><?php the_title(); ?></strong> <br/> DC fast chargers : <?php the_field("total_dc_fast_chargers"); ?> <br/> Connector Type: <?php the_field("connector_type"); ?> <br/> Power: <?php the_field("power"); ?> <br/> Status: <?php
                        $status = get_field('status');
                        if ($status == 'live') :
                            echo 'Live';
                        else:
                            echo 'Coming Soon';
                        endif;
                        ?>
                        ', <?php echo esc_attr($location['lat']); ?>, <?php echo esc_attr($location['lng']); ?>, <?php echo $i; ?>, '<?php the_field("status"); ?>'],
                        <?php endforeach; ?>
                    ];
                <?php wp_reset_postdata();
                endif; ?>
                var icons = {
                    live: {
                        icon: '<?= get_template_directory_uri(); ?>/images/map_marker.png'
                    },
                    comming_soon: {
                        icon: '<?= get_template_directory_uri(); ?>/images/map_marker_gray.png'
                    }

                };
                var map = new google.maps.Map(document.getElementById('map'), {
                    zoom: <?php the_sub_field('map_zoom_level'); ?>,
                    center: new google.maps.LatLng(<?php the_sub_field('map_center_level'); ?>),
                    mapTypeId: google.maps.MapTypeId.ROADMAP
                });

                var infowindow = new google.maps.InfoWindow();

                var marker, i;

                for (i = 0; i < locations.length; i++) {
                    marker = new google.maps.Marker({
                        position: new google.maps.LatLng(locations[i][1], locations[i][2]),
                        map: map,
                        icon: icons[locations[i][4]].icon,
                    });

                    google.maps.event.addListener(marker, 'click', (function (marker, i) {
                        return function () {
                            infowindow.setContent(locations[i][0]);
                            infowindow.open(map, marker);
                        }
                    })(marker, i));
                }
            </script>


        <?php elseif (get_row_layout() == 'left_text_with_bg_img'): ?>
            <section class="container-fluid position_relative left_text_with_bg_img">
                <img src="<?php the_sub_field('ltwbis_img'); ?>" class="right_bg">
                <div class="row">
                    <div class="container m_t_90 m_b_90">
                        <div class="row flex_col align_center">

                            <div class="col-sm-5  black_text title_text">
                                <h2><?php the_sub_field('ltwbi_title'); ?></h2>
                                <h3><?php the_sub_field('ltwbis_title'); ?></h3>
                                <p><?php the_sub_field('ltwbis_content'); ?></p>
                                <?php
                                $lbutton = get_sub_field('ltwbis_btn_text');
                                $lurl = get_sub_field('ltwbis_btn_link');
                                if (!empty($lbutton) && !empty($lurl)):
                                    ?>
                                    <a href="<?php echo $lurl; ?>" class="btn btn-primary"><?php echo $lbutton; ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'center_text_with_bg_img'): ?>
            <section class="container-fluid position_relative center_text_with_bg_img"
                     style="background: url(<?php the_sub_field('ctwbi_bf_img'); ?>) center center / cover no-repeat;">

                <div class="row" style="background: rgba(0,0,0,0.85)">
                    <div class="container m_t_60 m_b_60">
                        <div class="row flex_col align_center">

                            <div class="col-sm-6 col-sm-offset-3  text-center text_white title_text">
                                <h2><?php the_sub_field('ctwbi_title'); ?></h2>
                                <p><?php the_sub_field('ctwbi_content'); ?></p>
                                <?php
                                $cbutton = get_sub_field('ctwbi_btn_text');
                                $curl = get_sub_field('ctwbi_btn_link');
                                if (!empty($cbutton) && !empty($curl)):
                                    ?>
                                    <a href="<?php echo $curl; ?>"
                                       class="btn btn-primary m_t_20"><?php echo $cbutton; ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'text_with_box_and_img'): ?>
            <section class="container-fluid position_relative text_with_box_and_img" style="background: #000;">
                <img src="<?php the_sub_field('side_img'); ?>" class="left_bg">
                <div class="row">
                    <div class="container m_t_60 m_b_60">
                        <div class="row flex_col align_center">

                            <div class="col-sm-6 col-sm-offset-6  black_text title_text">
                                <div class="white_box">
                                    <h2><?php the_sub_field('stitle'); ?></h2>
                                    <p><?php the_sub_field('scontent'); ?></p>
                                    <?php
                                    $tbbutton = get_sub_field('sbtn_text');
                                    $tburl = get_sub_field('sbtn_link');
                                    if (!empty($tbbutton) && !empty($tburl)):
                                        ?>
                                        <a href="<?php echo $tburl; ?>"
                                           class="btn btn-primary m_t_20"><?php echo $tbbutton; ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'latest_blog_posts'): ?>
            <section class="container-fluid position_relative latest_blog_posts" style="background: <?php the_sub_field('bbg_color'); ?>">
                <div class="row">
                    <div class="container m_t_50 m_b_50">
                        <div class="row  ">

                            <div class="col-md-12 text-center  black_text title_text">
                                <h2><?php the_sub_field('lbp_title'); ?></h2>

                            </div>
                            <div class="col-md-12">
                                <div class="row">
                                    <?php
                                    $args = array(
                                        'post_type' => 'post',
                                        'posts_per_page' => 3,
                                    );
                                    $post_query = new WP_Query($args);
                                    if ($post_query->have_posts()) :
                                        while ($post_query->have_posts()) :
                                            $post_query->the_post(); ?>
                                            <div class="col-sm-4 col-xs-12">
                                                <div class="blog_box">
                                                    <img src="<?php the_post_thumbnail_url(); ?>"/>
                                                    <h3><?php the_title(); ?></h3>
                                                    <?php the_excerpt(); ?>
                                                    <a href="<?php the_permalink(); ?>" class="btn btn-primary">Learn
                                                        More</a>
                                                </div>
                                            </div>
                                        <?php
                                        endwhile;
                                    endif;
                                    wp_reset_postdata(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php elseif (get_row_layout() == 'contact_form'): ?>
            <section class="container-fluid position_relative contact_form"
                     style="background: url(<?php the_sub_field('cf_bg_img'); ?>) center center / cover no-repeat;">
                <div class="row" style="background: rgba(0,0,0,0.85)">
                    <div class="container m_t_50 m_b_80">
                        <div class="row">
                            <div class="col-md-12 text-center title_text">
                                <h2><?php the_sub_field('cftitle'); ?></h2>
                            </div>
                            <div class="col-md-6 col-md-offset-3">
                                <div class="contact_us_box">
                                    <?php
                                    $form = get_sub_field('cfform_shortcode');
                                    echo do_shortcode($form);
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <?php elseif (get_row_layout() == '4_box_section'): ?>
    <section class="container-fluid 4_box_section">
        <div class="row">
            <div class="container   m_b_90">
                <div class="row flex_col">
                    <?php
                    $i=0;
                    if (have_rows('step_box')):
                        while (have_rows('step_box')) : the_row(); $i++;?>
                            <div class="col-sm-6  col-xs-12">
                                <div class="circle_icon_box">
                                    <img src="<?php the_sub_field('sbimg'); ?>"/>
                                    <div>
										<h3>Step <?php echo $i; ?>: <b><?php the_sub_field('sbtitle'); ?></b></h3>
                                        <p><?php the_sub_field('sbcontent'); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                    endif;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'title_text_with_form'): ?>
    <section class="container-fluid position_relative title_text_with_form"  style="background: #f6f6f6" >
        <div class="row" >
            <div class="container m_t_50 m_b_50">
                <div class="row">
                    <div class="col-md-8 col-md-offset-2 text-center title_text black_text">
                        <h2><?php the_sub_field('ttwf_title'); ?></h2>
                        <p><?php the_sub_field('ttwf_content'); ?></p>
                    </div>
                    <div class="col-md-8 col-md-offset-2">
                        <div class="contact_us_box bigger">
                            <div class="row flex_col">
                                <?php
                                    $tform=get_sub_field('ttwf_form');
                                    echo do_shortcode($tform);
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php elseif (get_row_layout() == 'right_img_with_title_content'): ?>
    <section class="container-fluid position_relative right_img_with_title_content">
        <img src="<?php the_sub_field('riwtc_img'); ?>" class="right_bg">
        <div class="row">
            <div class="container m_t_90 m_b_90">
                <div class="row flex_col align_center">

                    <div class="col-sm-6 p_r_50  black_text title_text">
                        <h2><?php the_sub_field('riwtc_title'); ?></h2>
                        <p><?php the_sub_field('riwtc_content'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'img_content_with_bg_color'): ?>
    <section class="container-fluid position_relative img_content_with_bg_color" style="background:#f6f6f6;">

        <div class="row">
            <div class="container   m_t_40">
                <div class="row flex_col align_center">

                    <div class="col-sm-6 p_r_50 p_b_30  black_text title_text">
                        <h2><?php the_sub_field('icwbtitle'); ?></h2>
                        <?php the_sub_field('icwbcontent'); ?>
                    </div>
                    <div class="col-sm-6">
                        <img src="<?php the_sub_field('icwbimg'); ?>" class="img-responsive center-block" style="margin-bottom: -150px;" />
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'title_with_content'): ?>
    <section class="container-fluid title_with_content">
        <div class="row">
            <div class="container">
                <div class="row  m_t_40 m_b_60">
                    <div class="col-md-12 title_text black_text">
                        <h2><?php the_sub_field('tctitle'); ?></h2>
                        <p><?php the_sub_field('tccontent'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php elseif (get_row_layout() == 'img_with_button'): ?>
    <section class="container-fluid img_with_button" style="z-index: 22; position:relative;">
        <div class="row">
            <img src="<?php the_sub_field('iwb_bg_img'); ?>" class="full_width_img1"/>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $ibbutton = get_sub_field('iwb_btn_text');
                        $iburl = get_sub_field('iwb_btn_link');
                        if (!empty($ibbutton) && !empty($iburl)):
                            ?>
                            <a href="<?php echo $iburl; ?>"
                               class="btn btn-primary sponsar_station"><?php echo $ibbutton; ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'title_content_with_bg_img'): ?>
    <section class="container-fluid after_banner title_content_with_bg_img"
             style="background: url(<?php the_sub_field('tcwimg'); ?>) center center / cover no-repeat;">
        <div class="row">
            <div class="container m_t_90  m_b_70">
                <div class="row flex_col align_center">
                    <div class="col-sm-6 title_text black_text partner_b">
                        <h2><?php the_sub_field('tcwtitle'); ?></h2>
                        <p><?php the_sub_field('tcwcontent'); ?> </p>
                    </div>

                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == '3_logo'): ?>
    <section class="container-fluid 3_logo">
        <div class="row">
            <div class="container">
                <div class="row text-center m_t_40 m_b_40">
                    <?php
                    if (have_rows('3logo')):
                        while (have_rows('3logo')) : the_row(); ?>
                            <div class="col-md-4">
                                <img src="<?php the_sub_field('logoimg'); ?>"/>
                            </div>
                        <?php endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'bg_with_content'): ?>
    <section class="container-fluid position_relative bg_with_content" style="background:url(<?php the_sub_field('bwcimg'); ?>) center center / cover no-repeat;"  >
        <div class="row">
            <div class="container m_t_90  p_t_90 ">
                <div class="row">
                    <div class="col-md-6 col-md-offset-6 black_text title_text">
                        <div class="white_box2">
                            <h2><?php the_sub_field('bwctitle'); ?></h2>
                            <p><?php the_sub_field('bwccontent'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php elseif (get_row_layout() == 'title_conetnt_with_bg_color'): ?>
    <section class="container-fluid position_relative title_conetnt_with_bg_color" style="background:#f6f6f6;"  >
        <div class="row">
            <div class="container m_t_40  m_b_40 ">
                <div class="row">
                    <div class="col-md-8 black_text title_text">

                        <h2><?php the_sub_field('twctitle'); ?></h2>
                        <p><?php the_sub_field('twccontent'); ?></p>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'left_img_content_with_button'): ?>
    <section class="container-fluid position_relative left_img_content_with_button" style="background:#fff;"  >
        <div class="row">
            <div class="container m_t_90    ">
                <div class="row flex_col align_center">
                    <div class="col-md-6  black_text title_text">
                        <img src="<?php the_sub_field('liimg'); ?>" class="img-responsive center-block">
                    </div>
                    <div class="col-md-6 p_b_90  black_text title_text ipop_text">
                        <h2><?php the_sub_field('lititle'); ?></h2>
                        <?php the_sub_field('licontent'); ?>
                        <?php
                        $imbutton = get_sub_field('li_btn_text');
                        $imurl = get_sub_field('li_btn_link');
                        if (!empty($imbutton) && !empty($imurl)):
                            ?>
                            <a href="<?php echo $imurl; ?>"
                               class="btn btn-primary "><?php echo $imbutton; ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php elseif (get_row_layout() == 'content_with_right_img'): ?>
    <section class="container-fluid  position_relative content_with_right_img">

        <div class="row">
            <div class="container     m_b_40">
                <div class="row flex_col align_center">
                    <div class="col-sm-5 title_text black_text partner_b">
                        <h2><?php the_sub_field('cwr_title'); ?></h2>
                        <p><?php the_sub_field('cwr_content'); ?></p>
                    </div>
                    <div class="col-sm-7">
                        <img src="<?php the_sub_field('cwr_img'); ?>" class="img-responsive"/>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'icon_with_title_section'): ?>
    <section class="container-fluid position_relative icon_with_title_section" style="background:#f6f6f6;">

        <div class="row">
            <div class="container m_b_60   m_t_70">
                <div class="row flex_col align_center">

                    <div class="col-sm-8 col-sm-offset-2 text-center      black_text title_text">
                        <h2><?php the_sub_field('iwt_title'); ?></h2>
                        <p><?php the_sub_field('iwt_content'); ?></p>
                    </div>
                    <div class="col-sm-12">
                        <div class="icons_flexs">
                            <?php
                            if (have_rows('icon_box')):
                                while (have_rows('icon_box')) : the_row(); ?>
                                    <div class="ic_box">
                                        <img src="<?php the_sub_field('icon'); ?>"/>
                                        <h3><?php the_sub_field('title'); ?></h3>
                                    </div>
                                <?php endwhile;
                            endif;
                            wp_reset_postdata();
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'bg_img_with_content'): ?>
    <section class="container-fluid bg_img_with_content"
             style="background: url(<?php the_sub_field('bc_img'); ?>) center center / cover no-repeat;">
        <div class="row">
            <div class="container">
                <div class="row  m_t_40 m_b_80">
                    <div class="col-md-6 p_r_50 title_text black_text">
                        <h2><?php the_sub_field('bc_title'); ?></h2>
                        <p><?php the_sub_field('bc_content'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'counter_section'): ?>
    <section class="container-fluid counter_section">
        <div class="row">
            <div class="container m_t_40  m_b_40">
                <div class="row flex_col align_center">
                    <div class="col-sm-6 col-xs-12 p_r_50 title_text">
                        <h2><?php the_sub_field('ctitle'); ?></h2>
                        <p><?php the_sub_field('ccontent'); ?></p>
                    </div>
                    <div class="col-sm-6 col-xs-12   title_text">
                        <div class="row p_t_20">
                            <?php
                            if (have_rows('counter')):
                                while (have_rows('counter')) : the_row(); ?>
                                    <div class="col-md-4 p0">
                                        <div class="counter_box">
											<div class="counter_number"
                                                 style="background: url(<?php the_sub_field('cimg'); ?>) center center / 100% 100% no-repeat;">	 
                                             
                                                <?php the_sub_field('cno'); ?>
                                            </div>
                                            <h3><?php the_sub_field('ctext'); ?></h3>
                                        </div>
                                    </div>
                                <?php endwhile;
                            endif;
                            wp_reset_postdata();
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php elseif (get_row_layout() == 'text_with_button'): ?>

    <section class="container-fluid position_relative text_with_button" style="background: #f6f6f6;">

        <div class="container m_t_30 m_b_50">
            <div class="row">
                <div class="col-md-6 col-md-offset-3 text-center title_text">
                    <h2><?php the_sub_field('twb_text'); ?></h2>
                    <?php
                    $twbutton = get_sub_field('twb_btn_text');
                    $twurl = get_sub_field('twb_btn_link');
                    if (!empty($twbutton) && !empty($twurl)):
                        ?>
                        <a href="<?php echo $twurl; ?>"
                           class="btn btn-primary "><?php echo $twbutton; ?></a>
                    <?php endif; ?>
                </div>

            </div>
        </div>
        </div>
    </section>
        <?php endif;
    endwhile;
endif;
?>
<?php get_footer(); ?>