<?php
/**
 * WooCommerce Onboarding Tasks
 * NOTE: DO NOT edit this file in WooCommerce core, this is generated from woocommerce-admin.
 *
 * @package Woocommerce Admin
 */

/**
 * Contains the logic for completing onboarding tasks.
 */
class WC_Admin_Onboarding_Tasks {
	/**
	 * Class instance.
	 *
	 * @var WC_Admin_Onboarding_Tasks instance
	 */
	protected static $instance = null;

	/**
	 * Name of the active task transient.
	 *
	 * @var string
	 */
	const ACTIVE_TASK_TRANSIENT = 'wc_onboarding_active_task';

	/**
	 * Name of the tasks transient.
	 *
	 * @var string
	 */
	const TASKS_TRANSIENT = 'wc_onboarding_tasks';

	/**
	 * Get class instance.
	 */
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'woocommerce_components_settings', array( $this, 'component_settings' ), 30 ); // Run after WC_Admin_Onboarding.
		add_action( 'admin_init', array( $this, 'set_active_task' ), 20 );
		add_action( 'admin_init', array( $this, 'check_active_task_completion' ), 1 );
	}

	/**
	 * Add task items to component settings.
	 *
	 * @param array $settings Component settings.
	 */
	public function component_settings( $settings ) {
		$tasks = get_transient( self::TASKS_TRANSIENT );

		if ( ! $tasks ) {
			$tasks     = array();
			$task_list = array( 'products' );

			foreach ( $task_list as $task ) {
				$tasks[ $task ] = self::check_task_completion( $task );
			}

			set_transient( self::TASKS_TRANSIENT, $tasks, DAY_IN_SECONDS );
		}

		$settings['onboarding']['tasks'] = $tasks;

		return $settings;
	}


	/**
	 * Temporarily store the active task.
	 */
	public static function set_active_task() {
		if ( isset( $_GET[ self::ACTIVE_TASK_TRANSIENT ] ) ) { // WPCS: csrf ok.
			$task = sanitize_title_with_dashes( wp_unslash( $_GET[ self::ACTIVE_TASK_TRANSIENT ] ) );

			if ( self::check_task_completion( $task ) ) {
				return;
			}

			set_transient(
				self::ACTIVE_TASK_TRANSIENT,
				$task,
				DAY_IN_SECONDS
			); // WPCS: csrf ok.
		}
	}

	/**
	 * Check for active task completion and redirect if complete.
	 */
	public static function check_active_task_completion() {
		$active_task = get_transient( self::ACTIVE_TASK_TRANSIENT );
		if ( ! $active_task ) {
			return;
		}

		if ( self::check_task_completion( $active_task ) ) {
			delete_transient( self::ACTIVE_TASK_TRANSIENT );
			delete_transient( self::TASKS_TRANSIENT );
			wp_safe_redirect( wc_admin_url() );
			exit;
		}
	}

	/**
	 * Check for task completion of a given task.
	 *
	 * @param string $task Name of task.
	 * @return bool;
	 */
	public static function check_task_completion( $task ) {
		switch ( $task ) {
			case 'products':
				$products = wp_count_posts( 'product' );
				return (int) $products->publish > 0 || (int) $products->draft > 0;
		}

		return false;
	}
}

WC_Admin_Onboarding_Tasks::get_instance();
