<?php

add_theme_support( 'menus' );
add_theme_support( 'widgets' );
add_theme_support( 'post-thumbnails');

if( function_exists('acf_add_options_page') ) {
    acf_add_options_page();
    acf_set_options_page_menu("Theme Option");
}

add_action('admin_bar_menu', 'add_toolbar_items', 100);
function add_toolbar_items($admin_bar){
    $admin_bar->add_menu( array(
        'id'    => 'my-item',
        'title' => 'Theme Option',
        'href'  => site_url().'/wp-admin/admin.php?page=acf-options',
        'meta'  => array(
            'title' => __('Theme Option'),
        ),
    ));
}

function add_theme_scripts() {
    //    Style
    wp_enqueue_style( 'style-bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css');
    wp_enqueue_style( 'style-font-awesome', get_template_directory_uri() . '/css/font-awesome.css');
    wp_enqueue_style( 'style-owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css');
    wp_enqueue_style( 'style-animate', get_template_directory_uri() . '/css/animate.css');
    wp_enqueue_style( 'style-bootstrapcdn', 'https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css' );
    wp_enqueue_style( 'style-main', get_template_directory_uri() . '/css/style.css');
    wp_enqueue_style( 'style', get_stylesheet_uri() );

    // Script
    //wp_enqueue_script( 'script-jquery', get_template_directory_uri() . '/js/jquery.min.js', array(), null, true);
    wp_enqueue_script( 'script-bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array(), null, true);
    wp_enqueue_script( 'script-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array(), null, true);
    wp_enqueue_script( 'script-wow', get_template_directory_uri() . '/js/wow.js', array(), null, true);
    wp_enqueue_script( 'script-custom-script', get_template_directory_uri() . '/js/custom_script.js', array(), null, true);
}
add_action( 'wp_enqueue_scripts', 'add_theme_scripts' );

function register_my_menus() {
    register_nav_menus(
        array(
            'header_menu' => __( 'Header Menu' ),
            'footer_menu' => __( 'Footer Menu' ),
        )
    );
}
add_action( 'init', 'register_my_menus' );

function rrregister_sidebars() {

    /* Register the primary sidebar. */
    register_sidebar(
        array(
            'id' => 'sidebar-1',
            'name' => __( 'Footer Column One', 'theme' ),
            'description' => __( 'A short description of the sidebar.', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s footer_menu footer_item">',
            'after_widget' => '</div>',
            'before_title' => '<h4>',
            'after_title' => '</h4>'
        )
    );
    register_sidebar(
        array(
            'id' => 'sidebar-2',
            'name' => __( 'Footer Column Two', 'theme' ),
            'description' => __( 'A short description of the sidebar.', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s footer_menu footer_item">',
            'after_widget' => '</div>',
            'before_title' => '<h4>',
            'after_title' => '</h4>'
        )
    );
    register_sidebar(
        array(
            'id' => 'sidebar-3',
            'name' => __( 'Footer Column Three', 'theme' ),
            'description' => __( 'A short description of the sidebar.', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s footer_menu footer_item">',
            'after_widget' => '</div>',
            'before_title' => '<h4>',
            'after_title' => '</h4>'
        )
    );
    register_sidebar(
        array(
            'id' => 'sidebar-4',
            'name' => __( 'Sidebar', 'theme' ),
            'description' => __( 'Page sidebar', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s footer_menu footer_item">',
            'after_widget' => '</div>',
            'before_title' => '<h4>',
            'after_title' => '</h4>'
        )
    );
}
add_action( 'widgets_init', 'rrregister_sidebars' );
