<?php
/**
 * Twenty Nineteen functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since 1.0.0
 */

/**
 * Twenty Nineteen only works in WordPress 4.7 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '4.7', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
	return;
}

if ( ! function_exists( 'twentynineteen_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function twentynineteen_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Twenty Nineteen, use a find and replace
		 * to change 'twentynineteen' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'twentynineteen', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 1568, 9999 );

		// This theme uses wp_nav_menu() in two locations.
		register_nav_menus(
			array(
				'menu-1' => __( 'Primary', 'twentynineteen' ),
				'footer' => __( 'Footer Menu', 'twentynineteen' ),
				'social' => __( 'Social Links Menu', 'twentynineteen' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			)
		);

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 190,
				'width'       => 190,
				'flex-width'  => false,
				'flex-height' => false,
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Enqueue editor styles.
		add_editor_style( 'style-editor.css' );

		// Add custom editor font sizes.
		add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => __( 'Small', 'twentynineteen' ),
					'shortName' => __( 'S', 'twentynineteen' ),
					'size'      => 19.5,
					'slug'      => 'small',
				),
				array(
					'name'      => __( 'Normal', 'twentynineteen' ),
					'shortName' => __( 'M', 'twentynineteen' ),
					'size'      => 22,
					'slug'      => 'normal',
				),
				array(
					'name'      => __( 'Large', 'twentynineteen' ),
					'shortName' => __( 'L', 'twentynineteen' ),
					'size'      => 36.5,
					'slug'      => 'large',
				),
				array(
					'name'      => __( 'Huge', 'twentynineteen' ),
					'shortName' => __( 'XL', 'twentynineteen' ),
					'size'      => 49.5,
					'slug'      => 'huge',
				),
			)
		);

		// Editor color palette.
		add_theme_support(
			'editor-color-palette',
			array(
				array(
					'name'  => __( 'Primary', 'twentynineteen' ),
					'slug'  => 'primary',
					'color' => twentynineteen_hsl_hex( 'default' === get_theme_mod( 'primary_color' ) ? 199 : get_theme_mod( 'primary_color_hue', 199 ), 100, 33 ),
				),
				array(
					'name'  => __( 'Secondary', 'twentynineteen' ),
					'slug'  => 'secondary',
					'color' => twentynineteen_hsl_hex( 'default' === get_theme_mod( 'primary_color' ) ? 199 : get_theme_mod( 'primary_color_hue', 199 ), 100, 23 ),
				),
				array(
					'name'  => __( 'Dark Gray', 'twentynineteen' ),
					'slug'  => 'dark-gray',
					'color' => '#111',
				),
				array(
					'name'  => __( 'Light Gray', 'twentynineteen' ),
					'slug'  => 'light-gray',
					'color' => '#767676',
				),
				array(
					'name'  => __( 'White', 'twentynineteen' ),
					'slug'  => 'white',
					'color' => '#FFF',
				),
			)
		);

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );
	}
endif;
add_action( 'after_setup_theme', 'twentynineteen_setup' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function twentynineteen_widgets_init() {

    register_sidebar(
        array(
            'id' => 'sidebar-1',
            'name' => __( 'Footer Column One', 'theme' ),
            'description' => __( 'A short description of the sidebar.', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s footer_menu footer_item">',
            'after_widget' => '</div>',
            'before_title' => '<h4>',
            'after_title' => '</h4>'
        )
    );
    register_sidebar(
        array(
            'id' => 'sidebar-2',
            'name' => __( 'Footer Column Two', 'theme' ),
            'description' => __( 'A short description of the sidebar.', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s footer_menu footer_item">',
            'after_widget' => '</div>',
            'before_title' => '<h4>',
            'after_title' => '</h4>'
        )
    );
    register_sidebar(
        array(
            'id' => 'sidebar-3',
            'name' => __( 'Footer Column Three', 'theme' ),
            'description' => __( 'A short description of the sidebar.', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s footer_menu footer_item">',
            'after_widget' => '</div>',
            'before_title' => '<h4>',
            'after_title' => '</h4>'
        )
    );
    register_sidebar(
        array(
            'id' => 'sidebar-4',
            'name' => __( 'Footer Column Four', 'theme' ),
            'description' => __( 'A short description of the sidebar.', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s footer_menu footer_item">',
            'after_widget' => '</div>',
            'before_title' => '<h4>',
            'after_title' => '</h4>'
        )
    );
    register_sidebar(
        array(
            'id' => 'sidebar-5',
            'name' => __( 'Sidebar', 'theme' ),
            'description' => __( 'A short description of the sidebar.', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s footer_menu footer_item">',
            'after_widget' => '</div>',
            'before_title' => '<h2 class="menu_title m_b_20">',
            'after_title' => '</h2>'
        )
    );
    register_sidebar(
        array(
            'id' => 'sidebar-6',
            'name' => __( 'Popup Window', 'theme' ),
            'description' => __( 'A short description of the sidebar.', 'theme' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h2 class="">',
            'after_title' => '</h2>'
        )
    );

}
add_action( 'widgets_init', 'twentynineteen_widgets_init' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width Content width.
 */
function twentynineteen_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'twentynineteen_content_width', 640 );
}
add_action( 'after_setup_theme', 'twentynineteen_content_width', 0 );

/**
 * Enqueue scripts and styles.
 */
function twentynineteen_scripts() {
	wp_enqueue_style( 'twentynineteen-style', get_stylesheet_uri(), array(), wp_get_theme()->get( 'Version' ) );

	wp_style_add_data( 'twentynineteen-style', 'rtl', 'replace' );

	if ( has_nav_menu( 'menu-1' ) ) {
		wp_enqueue_script( 'twentynineteen-priority-menu', get_theme_file_uri( '/js/priority-menu.js' ), array(), '1.1', true );
		wp_enqueue_script( 'twentynineteen-touch-navigation', get_theme_file_uri( '/js/touch-keyboard-navigation.js' ), array(), '1.1', true );
	}

	wp_enqueue_style( 'twentynineteen-print-style', get_template_directory_uri() . '/print.css', array(), wp_get_theme()->get( 'Version' ), 'print' );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'twentynineteen_scripts' );

/**
 * Fix skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @link https://git.io/vWdr2
 */
function twentynineteen_skip_link_focus_fix() {
	// The following is minified via `terser --compress --mangle -- js/skip-link-focus-fix.js`.
	?>
	<script>
	/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
	</script>
	<?php
}
add_action( 'wp_print_footer_scripts', 'twentynineteen_skip_link_focus_fix' );

/**
 * Enqueue supplemental block editor styles.
 */
 

function twentynineteen_editor_customizer_styles() {
	wp_enqueue_style( 'style-animate', get_template_directory_uri() . '/css/animate.css');
    wp_enqueue_style( 'style-bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css');
    wp_enqueue_style( 'style-font-awesome', get_template_directory_uri() . '/css/font-awesome.css'); 
    wp_enqueue_style( 'style-owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css'); 
	wp_enqueue_style( 'style-xzoom', get_template_directory_uri() . '/css/xzoom.css'); 
    wp_enqueue_style( 'style-bootstrapcdn', 'https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css' );
    wp_enqueue_style( 'style-main', get_template_directory_uri() . '/css/style.css');
    wp_enqueue_style( 'style', get_stylesheet_uri() );

    // Script
    //wp_enqueue_script( 'script-jquery', get_template_directory_uri() . '/js/jquery.min.js', array(), null, true);
    wp_enqueue_script( 'script-navigation', get_template_directory_uri() . '/js/touch-keyboard-navigation.js', array(), null, true);
    wp_enqueue_script( 'script-bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array(), null, true);
    wp_enqueue_script( 'script-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array(), null, true);
	
	wp_enqueue_script( 'script-hammer', get_template_directory_uri() . '/js/jquery.hammer.min.js', array('jquery'), null, false);  
	  wp_enqueue_script( 'script-xzoom', get_template_directory_uri() . '/js/xzoom.min.js', array('jquery'), null, false);  
	  wp_enqueue_script( 'script-wow', get_template_directory_uri() . '/js/wow.js', array('jquery'), null, false); 
	
			wp_enqueue_script( 'script-setup', get_template_directory_uri() . '/js/setup.js', array('jquery'), null, false);
	wp_enqueue_script( 'script-custom-script', get_template_directory_uri() . '/js/custom_script.js', array('jquery'), null, false);
    
}
add_action( 'wp_enqueue_scripts', 'twentynineteen_editor_customizer_styles' );


/**
 * Display custom color CSS in customizer and on frontend.
 */
function twentynineteen_colors_css_wrap() {

	// Only include custom colors in customizer or frontend.
	if ( ( ! is_customize_preview() && 'default' === get_theme_mod( 'primary_color', 'default' ) ) || is_admin() ) {
		return;
	}

	require_once get_parent_theme_file_path( '/inc/color-patterns.php' );

	$primary_color = 199;
	if ( 'default' !== get_theme_mod( 'primary_color', 'default' ) ) {
		$primary_color = get_theme_mod( 'primary_color_hue', 199 );
	}
	?>

	<style type="text/css" id="custom-theme-colors" <?php echo is_customize_preview() ? 'data-hue="' . absint( $primary_color ) . '"' : ''; ?>>
		<?php echo twentynineteen_custom_colors_css(); ?>
	</style>
	<?php
}
add_action( 'wp_head', 'twentynineteen_colors_css_wrap' );

/**
 * SVG Icons class.
 */
require get_template_directory() . '/classes/class-twentynineteen-svg-icons.php';

/**
 * Custom Comment Walker template.
 */
require get_template_directory() . '/classes/class-twentynineteen-walker-comment.php';

/**
 * Enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * SVG Icons related functions.
 */
require get_template_directory() . '/inc/icon-functions.php';

/**
 * Custom template tags for the theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

if( function_exists('acf_add_options_page') ) {
    acf_add_options_page();
    acf_set_options_page_menu("Theme Option");
}

add_action('admin_bar_menu', 'add_toolbar_items', 100);
function add_toolbar_items($admin_bar){
    $admin_bar->add_menu( array(
        'id'    => 'my-item',
        'title' => 'Theme Option',
        'href'  => site_url().'/wp-admin/admin.php?page=acf-options',
        'meta'  => array(
            'title' => __('Theme Option'),
        ),
    ));
}

function register_my_menus() {
    register_nav_menus(
        array(
            'header_menu' => __( 'Header Menu' ),
            'footer_menu' => __( 'Footer Menu' ),
        )
    );
}
add_action( 'init', 'register_my_menus' );

remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30, 0);
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20, 0);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5, 0);
//remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30, 0);
//remove_action('woocommerce_after_shop_loop', 'woocommerce_pagination', 10, 0);

function iconic_available_attributes() {

}
add_shortcode('iconic_available_attributes','iconic_available_attributes');

function mfields_set_default_object_terms( $post_id, $post ) {
    if ( 'publish' === $post->post_status && $post->post_type === 'product' ) {
        $defaults = array(
            'products_filter' => array( 'all-product' )
        );
        $taxonomies = get_object_taxonomies( $post->post_type );

        foreach ( (array) $taxonomies as $taxonomy ) {
            $terms = wp_get_post_terms( $post_id, $taxonomy );
            if ( empty( $terms ) && array_key_exists( $taxonomy, $defaults ) ) {
                wp_set_object_terms( $post_id, $defaults[$taxonomy], $taxonomy );
            }
        }
    }
}
add_action( 'save_post', 'mfields_set_default_object_terms', 100, 2 );
//add_filter( 'loop_shop_per_page', 'new_loop_shop_per_page', 20 );
//
//function new_loop_shop_per_page( $cols ) {
//    // $cols contains the current number of products per page based on the value stored on Options -> Reading
//    // Return the number of products you wanna show per page.
//    $cols = 150;
//    return $cols;
//}

add_filter( 'woocommerce_breadcrumb_defaults', 'my_change_breadcrumb_delimiter' );
function my_change_breadcrumb_delimiter( $defaults ) {
    // Change the breadcrumb delimiter from '/' to '>'
    $defaults['delimiter'] = ' <span>></span> ';
    return $defaults;
}
function show_stock() {
global $product;
if ( $product->get_stock_quantity() ) { // if manage stock is enabled 
if ( number_format($product->get_stock_quantity(),0,'','') < 3 ) { // if stock is low
echo '<div class="remaining">Only ' . number_format($product->get_stock_quantity(),0,'','') . ' left in stock!</div>';
} else {
echo '<div class="remaining">' . number_format($product->get_stock_quantity(),0,'','') . ' left in stock</div>'; 
		}
	}
}

add_action('woocommerce_after_shop_loop_item','show_stock', 10);
function woocommerce_subcats_from_parentcat_by_ID($parent_cat_ID) {

   $args = array(

       'hierarchical' => 1,

       'show_option_none' => '',

       'hide_empty' => 0,

       'parent' => $parent_cat_ID,

     'taxonomy' => 'product_cat'

   );

$subcats = get_categories($args);

echo '<ul class="wooc_sclist">';

foreach ($subcats as $sc) {

       $link = get_term_link( $sc->slug, $sc->taxonomy );

echo '<li><a href="'. $link .'">'.$sc->name.'</a></li>';

     }

echo '</ul>';

}

function woocommerce_template_loop_category_title( $category ) {
    ?>
		<h3 class="woocommerce-loop-category__title">
			<?php
      echo esc_html( $category->name );

      if ( $category->count > 0 ) {
        echo apply_filters( 'woocommerce_subcategory_count_html', ' <mark class="count">(' . esc_html( $category->count ) . ')</mark>', $category ); // WPCS: XSS ok.
      }
      ?>
		</h3>
		<?php
  }
