<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

?>
	<header class="woocommerce-products-header">
		<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
			<!--		<h1 class="woocommerce-products-header__title page-title">--><?php //woocommerce_page_title(); ?><!--</h1>-->
		<?php endif; ?>

		<?php
		/**
		 * Hook: woocommerce_archive_description.
		 *
		 * @hooked woocommerce_taxonomy_archive_description - 10
		 * @hooked woocommerce_product_archive_description - 10
		 */
		do_action( 'woocommerce_archive_description' );
		?>
	</header>
<?php
$term = get_queried_object();
$cateID = $term->term_id;
$image = get_field('cat_bg_img', $term);
?>

	<section class="slider" style="background:url(<?php if (!empty($image)): echo $image['url']; else: echo "https://nikunj.creativamotions.com/hub/wp-content/uploads/2019/07/page_banner.png"; endif; ?>) center center / cover no-repeat;  ">

	</section>
	<div class="woocommerce"></div>
	<section class="container-fluid ">
		<div class="row inner_containers ">
			<div class="col-md-12 border_bottom  ">
				<div class="row">
					<a href="javascript:void(0);" class="filter_sec"><i class="fa fa-filter"></i> Filter</a>
					<div class="col-sm-3 p_t_30 p_b_50 border_bottom_sm    slide_lefters">
						<?php dynamic_sidebar('sidebar-5'); ?>
					</div>
					<div class="col-sm-9 p_t_50 m_b_90 custom_seas">
						<div class="row m0 ">
							<div class="col-md-12 p0 m_b_30 border_bottom">

								<div class="tablee">
									<div class="col-md-7 p0  tablee_cell remove_price">
										<?php echo do_shortcode("[woof tax_only='products_filter']"); ?>
										<!--                            <ul class="list-inline product_filter">-->
										<!--                                <li class="active"><a href="">All Products</a></li>-->
										<!--                                <li><a href="">Hot Products</a></li>-->
										<!--                                <li><a href="">New Products</a></li>-->
										<!--                                <li><a href="">Sales Products</a></li>-->
										<!--                            </ul>-->
									</div>
									<div class="col-md-5  p0 tablee_cell text-right">
										<div class="flex_category">


											<p class="showing_products"><?php woocommerce_result_count(); ?></p>

										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<?php
								if ( woocommerce_product_loop() ) {
				
									/**
									 * Hook: woocommerce_before_shop_loop.
									 *
									 * @hooked woocommerce_output_all_notices - 10
									 * @hooked woocommerce_result_count - 20
									 * @hooked woocommerce_catalog_ordering - 30
									 */
									do_action( 'woocommerce_before_shop_loop' );
				
									woocommerce_product_loop_start();
									if ( wc_get_loop_prop( 'total' ) ) {
										while ( have_posts() ) {
											the_post();
											/**
											 * Hook: woocommerce_shop_loop.
											 *
											 * @hooked WC_Structured_Data::generate_product_data() - 10
											 */
											do_action( 'woocommerce_shop_loop' );
				
											wc_get_template_part( 'content', 'product' );
										}
									}
									woocommerce_product_loop_end();
				
									/**
									 * Hook: woocommerce_after_shop_loop.
									 *
									 * @hooked woocommerce_pagination - 10
									 */
									do_action( 'woocommerce_after_shop_loop' );
								} else {
									/**
									 * Hook: woocommerce_no_products_found.
									 *
									 * @hooked wc_no_products_found - 10
									 */
									do_action( 'woocommerce_no_products_found' );
								}
				
								/**
								 * Hook: woocommerce_after_main_content.
								 *
								 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
								 */
								do_action( 'woocommerce_after_main_content' );
				
								/**
								 * Hook: woocommerce_sidebar.
								 *
								 * @hooked woocommerce_get_sidebar - 10
								 */
								do_action( 'woocommerce_sidebar' ); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php
get_footer( 'shop' );