<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>

<div class="col-md-3 col-sm-6 same_height custom-product  wow fadeIn" data-wow-duration="2s">
    <a href="<?php the_permalink(); ?>">
        <div class="featured_product_box">
            <div class="featured_image">
               <?php woocommerce_template_loop_product_thumbnail(); ?>
            </div>
            <?php
            $pd_bg_clr = get_field('pd_bg_clr');
            $product_discount = get_field('product_discount');
            if (!empty($product_discount)) :
            ?>
            <span class="ribbin green" style="background-color: <?= $pd_bg_clr; ?>"><?= $product_discount ?></span>
            <?php endif; ?>

                <h3><?php the_title(); ?></h3>
                <h3><?php woocommerce_template_loop_price(); ?></h3>
        </div>
    </a>
</div>