<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since Twenty Nineteen 1.0
 */
?>
<!DOCTYPE html>
<html>
	<head>
		<title>
			<?php   if (is_404()): echo "Page Not Found"; else: echo get_the_title(); endif; echo " - ".get_bloginfo(); ?>
		</title>
		<meta charset="utf-8">
		<meta name="HandheldFriendly" content="True">
		<meta name="MobileOptimized" content="320">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<?php $favicon = get_field('hfaviicon', 'option');   	
		if (!empty($favicon)): ?>     
		<link rel="icon" type="image/x-icon" href="<?php echo $favicon['url']; ?>">     
		<?php endif; ?>		
		<?php wp_head();?>	
	</head>
	<body <?php body_class();?>>
		<header class="container-fluid">
			<div class="row preheader">
				<div class="container">
					<div class="row flex_col align_center">
						<div class="col-md-12 text-right">
							<?php $pnum = get_field('phone_number','option');
							if(!empty($pnum)):?>
							<a href="tel:<?php echo $pnum;?>"><i class="fa fa-phone"></i> <?php echo $pnum;?></a>
							<?php endif;?>
							<?php $eml = get_field('email_address','option');
							if(!empty($eml)):?>
							<a href="mailto:<?php echo $eml;?>"><i class="fa fa-envelope"></i> <?php echo $eml;?></a>
							<?php endif;?>
								<?php pll_the_languages(array('dropdown'=>1));  ?>
						</div>
					</div>
				</div>
			</div>
	 		<div class="row">
	 			<nav class="navbar navbar-default">
				  <div class="container p0">
				    <!-- Brand and toggle get grouped for better mobile display -->
				    <div class="navbar-header">
				      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
				        <span class="sr-only">Toggle navigation</span>
				        <span class="icon-bar"></span>
				        <span class="icon-bar"></span>
				        <span class="icon-bar"></span>
				      </button>
				      <a class="navbar-brand" href="<?php echo pll_home_url();?>"><img src="<?php the_field('hlogo','option'); ?>" /></a>
				    </div>

				    <!-- Collect the nav links, forms, and other content for toggling -->
				    <div class="collapse navbar-collapse navbar-right" id="bs-example-navbar-collapse-1">
				      <?php
							wp_nav_menu(array(
							'theme_location' => 'primary',
							'menu_class' => 'nav navbar-nav', 
							'container' => false										
							));
						?> 
				      <ul class="nav navbar-nav search_icon">
				      	<li><a href=""><img src="<?php echo get_template_directory_uri(); ?>/images/search.svg" /></a></li>
				      </ul>
				      <?php
							wp_nav_menu(array(
							'theme_location' => 'bmenu',
							'menu_class' => 'nav navbar-nav',  
							 'container' => false
							));
						?> 
				      
				    </div><!-- /.navbar-collapse -->
				  </div><!-- /.container-fluid -->
				</nav>
	 		</div>
	 	</header>