<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Zapp
 */

?>

<footer class="container-fluid">
    <div class="row">
        <div class="container position_relative">
        <a href="javascript:void(0);" class="go_to_top">
            <img src="https://nikunj.creativamotions.com/zapp/wp-content/uploads/2020/07/go_to_top.png" /></a>

            <div class="row m_t_90 m_b_90 flex_col">
                <div class="col-md-10 p0">
                    <div class="row m0 flex_col">
                        <div class="col-md-3 col-sm-6  col-xs-12 p0">
                            <h3><?php the_field('section1_title','options'); ?></h3>
                            <?php
                                wp_nav_menu(
                                    array(
                                        'menu' => false,
                                        'theme_location' => 'footer1',
                                        'link_before' => false,
                                        'link_after' => false,
                                        'menu_class' => false,
                                        'menu_id' => false,
                                        'container' => false,
                                    )
                                );
                            ?>
                        </div>
                        <div class="col-md-3 col-sm-6  col-xs-12  p0">
                            <h3><?php the_field('section2_title','options'); ?></h3>
                            <?php
                            wp_nav_menu(
                                array(
                                    'menu' => false,
                                    'theme_location' => 'footer2',
                                    'link_before' => false,
                                    'link_after' => false,
                                    'menu_class' => false,
                                    'menu_id' => false,
                                    'container' => false,
                                )
                            );
                            ?>
                        </div>
                        <div class="col-md-3 col-sm-6  col-xs-12  p0">
                            <h3><?php the_field('section3_title','options'); ?></h3>
                            <?php
                            wp_nav_menu(
                                array(
                                    'menu' => false,
                                    'theme_location' => 'footer3',
                                    'link_before' => false,
                                    'link_after' => false,
                                    'menu_class' => false,
                                    'menu_id' => false,
                                    'container' => false,
                                )
                            );
                            ?>
                        </div>
                        <div class="col-md-3 col-sm-6  col-xs-12  p0">
                            <h3><?php the_field('section4_title','options'); ?></h3>
                            <?php
                            wp_nav_menu(
                                array(
                                    'menu' => false,
                                    'theme_location' => 'footer4',
                                    'link_before' => false,
                                    'link_after' => false,
                                    'menu_class' => false,
                                    'menu_id' => false,
                                    'container' => false,
                                )
                            );
                            ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-2 p0 social">
                    <h3><br/></h3>
                    <?php
                    if( have_rows('social_icon','option') ):
                        while ( have_rows('social_icon','option') ) : the_row();
                            ?>
                            <a href="<?php the_sub_field('surl','option'); ?>">
                                <i class="fa <?php the_sub_field('sicon','option'); ?>"></i></a>
                        <?php
                        endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
            <div class="row copy_right">
                <div class="col-md-12 text-center">
                    <p><?php the_field('copyright','options'); ?></p>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php wp_footer(); ?>

<script src="<?= get_template_directory_uri(); ?>/js/bootstrap.min.js"></script>
<script src="<?= get_template_directory_uri(); ?>/js/owl.carousel.js"></script>
<script src="<?= get_template_directory_uri(); ?>/js/wow.js"></script>

<script src="<?= get_template_directory_uri(); ?>/js/custom_script.js"></script>
 
         
</body>
</html>