<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Zapp
 */

?>
<!DOCTYPE html>
<html>
<head>
    <title>
        <?php if (is_404()): echo "Page Not Found"; else: echo get_the_title(); endif; echo " - ".get_bloginfo(); ?>
    </title>
    <meta charset="utf-8">
    <meta name="HandheldFriendly" content="True">
    <meta name="MobileOptimized" content="320">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <?php
        $favicon=get_field('favicon','option');
            if (!empty($favicon)):
                echo "<link rel=\"icon\" type=\"image/x-icon\" href=\"$favicon\">";
            endif;
    ?>
    <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/css/bootstrap.min.css"/>
    <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/css/font-awesome.css"/>
    <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/css/owl.carousel.css"/>
    <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/css/animate.css"/>
    <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/css/style.css"/>
    <link rel="stylesheet" href="<?= get_template_directory_uri(); ?>/style.css"/>
    <?php wp_head(); ?>
	<script src="<?= get_template_directory_uri(); ?>/js/jquery.min.js"></script>
	<script src="https://maps.google.com/maps/api/js?key=AIzaSyDvRtp2c-tiMAbETRuCSiWIB4jlpqJ_Pnk" 
          type="text/javascript"></script>
</head>
<body <?php body_class(); ?>>
<header class="container-fluid">
    <div class="row">
        <nav class="navbar navbar-default">
            <div class="row">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="<?php echo site_url(); ?>"><img src="<?php the_field('hlogo','options'); ?>" /></a>
                </div>

                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse navbar-right" id="bs-example-navbar-collapse-1">
                    <?php
                        wp_nav_menu(
                            array(
                                'menu' => false,
                                'theme_location' => 'menu-1',
                                'link_before' => false,
                                'link_after' => false,
                                'menu_class' => "nav navbar-nav",
                                'menu_id' => false,
                                'container' => false,
                            )
                        );
                    ?>
                </div><!-- /.navbar-collapse -->
            </div><!-- /.container-fluid -->
        </nav>
    </div>
</header>